/***********************************************************************/
/*    Physical Block                                                   */
/***********************************************************************/

BLOCK physical_block
{
    TYPE    PHYSICAL;
    NUMBER    1;
}

VARIABLE phys_blk_reserve
{
    LABEL       [blk_reserved];
    HELP        [blk_reserved_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE phys_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        {    1,    [blk_block_object_PHYSICAL]    }
    }
    HANDLING    READ;
}

VARIABLE phys_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [phys_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [phys_blk_parent_class_TRANSMITTER]    }
    }
    HANDLING    READ;
}

VARIABLE phys_blk_class
{
    LABEL       [blk_class];
    HELP        [phys_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        DEFAULT_VALUE    250;
        {    250,    [not_used]        }
    }
    HANDLING    READ;
}

VARIABLE phys_blk_dd_reference
{
    LABEL       [blk_dd_reference];
    HELP        [blk_dd_reference_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
  {
      DEFAULT_VALUE    0;
  }
    HANDLING    READ;
}

VARIABLE phys_blk_dd_rev
{
    LABEL       [blk_dd_rev];
    HELP        [blk_dd_rev_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER(2)
  {
      DEFAULT_VALUE    0;
  }
    HANDLING    READ;
}

VARIABLE phys_blk_profile
{
    LABEL       [blk_profile];
    HELP        [blk_profile_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
      DEFAULT_VALUE 0x4002;
        { 0x4001,    [blk_profile_PA_COMPACT_A]   },
        { 0x4002,    [blk_profile_PA_COMPACT_B]   },
        { 0x4081,    [blk_profile_PA_SIMPLE_A]    },
        { 0x4082,    [blk_profile_PA_SIMPLE_B]    }
    }
    HANDLING    READ;
}

VARIABLE phys_blk_profile_rev
{
    LABEL       [blk_profile_rev];
    HELP        [blk_profile_rev_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE    0x0302;
        {    0x025A,    "2.90"    },
        {    0x025B,    "2.91"    },
        {    0x025C,    "2.92"    },
        {    0x025D,    "2.93"    },
        {    0x025E,    "2.94"    },
        {    0x025F,    "2.95"    },
        {    0x0260,    "2.96"    },
        {    0x0261,    "2.97"    },
        {    0x0262,    "2.98"    },
        {    0x0263,    "2.99"    },
        {    0x0300,    "3.0"     },
        {    0x0301,    "3.01"    },
        {    0x0302,    "3.02"    }
    }
    HANDLING    READ;
}

VARIABLE phys_blk_execution_time
{
    LABEL       [blk_execution_time];
    HELP        [blk_execution_time_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER(1);
    HANDLING    READ;
}

VARIABLE phys_blk_num_parameters
{
    LABEL       [blk_num_parameters];
    HELP        [blk_num_parameters_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE phys_blk_index_view_1
{
    LABEL       [blk_index_view_1];
    HELP        [blk_index_view_1_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE phys_blk_num_view_lists
{
    LABEL       [blk_num_view_lists];
    HELP        [blk_num_view_lists_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE phys_st_rev
{
    LABEL       [st_rev];
    HELP        [st_rev_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ;
}

VARIABLE phys_tag_desc
{
    LABEL       [MC_phys_tag_desc];
    HELP        [tag_desc_help];
    CLASS       CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE  DEVICE_NAME;
    }
    HANDLING    READ & WRITE;   
}

VARIABLE phys_strategy
{
    LABEL       [strategy];
    HELP        [strategy_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_alert_key
{
    LABEL       [alert_key];
    HELP        [alert_key_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE   0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        {    0x08,    [mode_AUTO]              },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE phys_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    0x88;
        {    0x08,    [mode_AUTO]              },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE phys_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        {    0x08,    [mode_AUTO]              },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE phys_current_state_alarm_sum
{
    LABEL       [current_state_alarm_sum];
    HELP        [current_state_alarm_sum_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x8000,    [limit_state_ST_REV]    }
    }
    HANDLING    READ;
}

VARIABLE phys_unacknowledged_state_alarm_sum
{
    LABEL       [unacknowledged_state_alarm_sum];
    HELP        [unacknowledged_state_alarm_sum_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x8000,    [limit_state_ST_REV]    }
    }
    HANDLING    READ;
}

VARIABLE phys_unreported_state_alarm_sum
{
    LABEL       [unreported_state_alarm_sum];
    HELP        [unreported_state_alarm_sum_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x8000,    [limit_state_ST_REV]    }
    }
    HANDLING    READ;
}

VARIABLE phys_disabled_state_alarm_sum
{
    LABEL       [disabled_state_alarm_sum];
    HELP        [disabled_state_alarm_sum_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x8000,    [limit_state_ST_REV]    }
    }
    HANDLING    READ;
}

VARIABLE phys_software_rev
{
    LABEL       [phys_software_revision];
    HELP        [phys_software_revision_help];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "1.0";
    }
    HANDLING    READ;
}

VARIABLE phys_hardware_rev
{
    LABEL       [phys_hardware_revision];
    HELP        [phys_hardware_revision_help];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE    "1.0";
    }
    HANDLING    READ;
}

VARIABLE phys_device_man_id
{
    LABEL       [phys_device_man_id];
    HELP        [phys_device_man_id_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE     0x16C;
            { 0x16C,      [MC_Manufacturer]        },
            { 250,        [not_used]               },
            { 251,        [none]                   },
            { 252,        [unknown]                },
            { 253,        [special]                }
    }
    HANDLING    READ;
}

VARIABLE phys_device_id
{
    LABEL       [phys_device_type];
    HELP        [phys_device_type_help];
    CLASS       CONTAINED;
    TYPE        ASCII (16) 
    {
        DEFAULT_VALUE DEVICE_NAME;
    }
    HANDLING    READ;
}

VARIABLE phys_device_ser_num
{
    LABEL       [phys_device_ser_num];
    HELP        [phys_device_ser_num_help];
    CLASS       CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE   "0";
    }
    HANDLING    READ;
    PURPOSE        "Device.Ident.SerialNumber";
}

//#define DIA_HW_ELECTR            0x01000000        /* 0x00000001 */
//#define DIA_HW_MECH              0x02000000        /* 0x00000002 */
//#define DIA_TEMP_MOTOR           0x04000000        /* 0x00000004 */
//#define DIA_TEMP_ELECTR          0x08000000        /* 0x00000008 */
//#define DIA_MEM_CHKSUM           0x10000000        /* 0x00000010 */
//#define DIA_MEASUREMENT          0x20000000        /* 0x00000020 */
//#define DIA_NOT_INIT             0x40000000        /* 0x00000040 */
//#define DIA_INIT_ERR             0x80000000        /* 0x00000080 */

//#define DIA_ZERO_ERR             0x00010000        /* 0x00000100 */
//#define DIA_SUPPLY               0x00020000        /* 0x00000200 */
//#define DIA_CONF_INVAL           0x00040000        /* 0x00000400 */
#define DIA_WARMSTART            0x00080000        /* 0x00000800 */
#define DIA_COLDSTART            0x00100000        /* 0x00001000 */
#define DIA_MAINTENANCE          0x00200000        /* 0x00002000 */
//#define DIA_CHARACT              0x00400000        /* 0x00004000 */
#define IDENT_NUMBER_VIOLATION   0x00800000        /* 0x00008000 */

#define DIA_MAINTENANCE_ALARM    0x00000100        /* 0x00010000 */
#define DIA_MAINTENANCE_DEMANDED 0x00000200        /* 0x00020000 */
#define DIA_FUNCTION_CHECK       0x00000400        /* 0x00040000 */
#define DIA_INV_PRO_COND         0x00000800        /* 0x00080000 */

#define EXTENSION_AVAILABLE      0x00000080        /* 0x80000000 */

VARIABLE phys_diagnosis
{
    LABEL       [phys_diagnosis];
    HELP        [phys_diagnosis_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        BIT_ENUMERATED (4)
    {
        { 0,                        [dia_OK],                        [dia_OK_help]                        },
//        { DIA_HW_ELECTR,            [dia_HW_ELECTR],                 [dia_HW_ELECTR_help]                 },
//        { DIA_HW_MECH,              [dia_HW_MECH],                   [dia_HW_MECH_help]                   },
//        { DIA_TEMP_MOTOR,           [dia_TEMP_MOTOR],                [dia_TEMP_MOTOR_help]                },
//        { DIA_TEMP_ELECTR,          [dia_TEMP_ELECTR],               [dia_TEMP_ELECTR_help]               },
//        { DIA_MEM_CHKSUM,           [dia_MEM_CHKSUM],                [dia_MEM_CHKSUM_help]                },
//        { DIA_MEASUREMENT,          [dia_MEASUREMENT],               [dia_MEASUREMENT_help]               },
//        { DIA_NOT_INIT,             [dia_NOT_INIT],                  [dia_NOT_INIT_help]                  },
//        { DIA_INIT_ERR,             [dia_INIT_ERR],                  [dia_INIT_ERR_help]                  },
//        { DIA_ZERO_ERR,             [dia_ZERO_ERR],                  [dia_ZERO_ERR_help]                  },
//        { DIA_SUPPLY,               [dia_SUPPLY],                    [dia_SUPPLY_help]                    },
//        { DIA_CONF_INVAL,           [dia_CONF_INVAL],                [dia_CONF_INVAL_help]                },
        { DIA_WARMSTART,            [dia_WARMSTART],                 [dia_WARMSTART_help]                 },
        { DIA_COLDSTART,            [dia_COLDSTART],                 [dia_COLDSTART_help]                 },
        { DIA_MAINTENANCE,          [dia_MAINTENANCE],               [dia_MAINTENANCE_help]               },
//        { DIA_CHARACT,              [dia_CHARACT],                   [dia_CHARACT_help]                   },
        { IDENT_NUMBER_VIOLATION,   [MC_dia_IDENT_NUMBER_VIOLATION], [MC_dia_IDENT_NUMBER_VIOLATION_help] },
        { DIA_MAINTENANCE_ALARM,    [MC_dia_MAINTENANCE_ALARM],      [MC_dia_MAINTENANCE_ALARM_help]      },
        { DIA_MAINTENANCE_DEMANDED, [MC_dia_MAINTENANCE_DEMANDED],   [MC_dia_MAINTENANCE_DEMANDED_help]   },
        { DIA_FUNCTION_CHECK,       [MC_dia_FUNCTION_CHECK],         [MC_dia_FUNCTION_CHECK_help]         },
        { DIA_INV_PRO_COND,         [MC_dia_INV_PRO_COND],           [MC_dia_INV_PRO_COND_help]           },
        { EXTENSION_AVAILABLE,      [MC_dia_EXTENSION_AVAILABLE],    [dia_EXTENSION_AVAILABLE_help]       }
    }
    HANDLING    READ;
    STYLE       "MULTILINE 16 9" ;
}

VARIABLE phys_diagnosis_mask
{
    LABEL       [phys_diagnosis_mask];
    HELP        [phys_diagnosis_mask_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (4)
    {
        { 0,                        [dia_OK],                        [dia_OK_help]                        },
//        { DIA_HW_ELECTR,            [dia_HW_ELECTR],                 [dia_HW_ELECTR_help]                 },
//        { DIA_HW_MECH,              [dia_HW_MECH],                   [dia_HW_MECH_help]                   },
//        { DIA_TEMP_MOTOR,           [dia_TEMP_MOTOR],                [dia_TEMP_MOTOR_help]                },
//        { DIA_TEMP_ELECTR,          [dia_TEMP_ELECTR],               [dia_TEMP_ELECTR_help]               },
//        { DIA_MEM_CHKSUM,           [dia_MEM_CHKSUM],                [dia_MEM_CHKSUM_help]                },
//        { DIA_MEASUREMENT,          [dia_MEASUREMENT],               [dia_MEASUREMENT_help]               },
//        { DIA_NOT_INIT,             [dia_NOT_INIT],                  [dia_NOT_INIT_help]                  },
//        { DIA_INIT_ERR,             [dia_INIT_ERR],                  [dia_INIT_ERR_help]                  },
//        { DIA_ZERO_ERR,             [dia_ZERO_ERR],                  [dia_ZERO_ERR_help]                  },
//        { DIA_SUPPLY,               [dia_SUPPLY],                    [dia_SUPPLY_help]                    },
//        { DIA_CONF_INVAL,           [dia_CONF_INVAL],                [dia_CONF_INVAL_help]                },
        { DIA_WARMSTART,            [dia_WARMSTART],                 [dia_WARMSTART_help]                 },
        { DIA_COLDSTART,            [dia_COLDSTART],                 [dia_COLDSTART_help]                 },
        { DIA_MAINTENANCE,          [dia_MAINTENANCE],               [dia_MAINTENANCE_help]               },
//        { DIA_CHARACT,              [dia_CHARACT],                   [dia_CHARACT_help]                   },
        { IDENT_NUMBER_VIOLATION,   [MC_dia_IDENT_NUMBER_VIOLATION], [MC_dia_IDENT_NUMBER_VIOLATION_help] },
        { DIA_MAINTENANCE_ALARM,    [MC_dia_MAINTENANCE_ALARM],      [MC_dia_MAINTENANCE_ALARM_help]      },
        { DIA_MAINTENANCE_DEMANDED, [MC_dia_MAINTENANCE_DEMANDED],   [MC_dia_MAINTENANCE_DEMANDED_help]   },
        { DIA_FUNCTION_CHECK,       [MC_dia_FUNCTION_CHECK],         [MC_dia_FUNCTION_CHECK_help]         },
        { DIA_INV_PRO_COND,         [MC_dia_INV_PRO_COND],           [MC_dia_INV_PRO_COND_help]           },
        { EXTENSION_AVAILABLE,      [MC_dia_EXTENSION_AVAILABLE],    [dia_EXTENSION_AVAILABLE_help]       }
    }
    HANDLING    READ;
    STYLE       "MULTILINE 16 9" ;
}

/*
VARIABLE phys_diagnosis_extension
{
    LABEL        [phys_diagnosis_extension];
    HELP        [phys_diagnosis_extension_help];
    CLASS        CONTAINED;
    TYPE        ASCII (6);
    HANDLING    READ;
}

VARIABLE phys_diagnosis_extension_mask
{
    LABEL        [phys_diagnosis_extension_mask];
    HELP        [phys_diagnosis_extension_mask_help];
    CLASS        CONTAINED;
    TYPE        ASCII (6);
    HANDLING    READ;
}
*/

VARIABLE phys_device_certification                    /* optional */
{
    LABEL        [phys_device_certification];
    HELP        [phys_device_certification_help];
    CLASS        CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE "See plate";
    }
    HANDLING    READ;
}

VARIABLE phys_write_locking                            /* optional */
{
    LABEL        [phys_write_locking];
    HELP        [phys_write_locking_help];
    CLASS        CONTAINED;
    TYPE        ENUMERATED(2)
    {
        DEFAULT_VALUE   2457;
        { 2457, [off]   },
        { 0,    [on]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_factory_reset                         /* optional */
{
    LABEL        [phys_factory_reset];
    HELP        [phys_factory_reset_help];
    CLASS        CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE    0;
        { 0,        [no_function]           },
        { 1,        [factory_reset_PARAMS]  },
        { 2506,        [phys_device_reset_cmd] },
        { 2712,     [factory_reset_ADDRESS] } 
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_descriptor                            /* optional */
{
    LABEL        [phys_descriptor];
    HELP        [phys_descriptor_help];
    CLASS        CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE " ";
    }
    HANDLING    READ & WRITE;
    PURPOSE        "Device.App.Ident.Description";
}

VARIABLE phys_message                                /* optional */
{
    LABEL        [phys_message];
    HELP        [phys_message_help];
    CLASS        CONTAINED;
    TYPE        ASCII (32)
    {
        DEFAULT_VALUE " ";
    }
    HANDLING    READ & WRITE;
    PURPOSE        "Device.App.Ident.Message";
}

VARIABLE phys_install_date                            /* optional */
{
    LABEL        [phys_install_date];
    HELP        [phys_install_date_help];
    CLASS        CONTAINED;
    TYPE        ASCII (16)
    {
        DEFAULT_VALUE "2008-01-01";
    }
    HANDLING    READ & WRITE;
    PURPOSE        "Device.App.Ident.InstallDate";
}

VARIABLE phys_local_operation_enable
{
    LABEL        [trans_act_local_operation];
    HELP        [trans_act_local_operation_help];
    CLASS        CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    1;
        {    0,    [disabled]    },
        {    1,    [enabled]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_ident_number
{
    LABEL        [phys_ident_number];
    HELP        [phys_ident_number_help];
    CLASS        CONTAINED;
    TYPE        ENUMERATED (1)
    {
        {    0,    [phys_ident_number_PROFILE]        },
        {    1,    [phys_ident_number_MANUFACURER]    },
        {    127,  [MC_ident_number_ADAPTATION]       }
    }
    HANDLING    READ & WRITE;
}

VARIABLE phys_hw_write_protection
{
    LABEL        [phys_hw_write_protection];
    HELP        [phys_hw_write_protection_help];
    CLASS        CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    1;
        {    0,    [off]    },
        {    1,    [on]    }
    }
    HANDLING    READ;
}

/*---------------------------------------------------------------------*/
/*    Physical Block: (Commands)                                       */
/*---------------------------------------------------------------------*/
COMMAND read_phys_blk
{
    BLOCK physical_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_blk_reserve,
            phys_blk_object,
            phys_blk_parent_class,
            phys_blk_class,
            phys_blk_dd_reference,
            phys_blk_dd_rev,
            phys_blk_profile,
            phys_blk_profile_rev,
            phys_blk_execution_time,
            phys_blk_num_parameters,
            phys_blk_index_view_1,
            phys_blk_num_view_lists
        }
    }
}

COMMAND read_phys_st_rev
{
    BLOCK physical_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_st_rev
        }
    }
}

COMMAND read_phys_tag_desc
{
    BLOCK physical_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_tag_desc
        }
    }
}

COMMAND write_phys_tag_desc
{
    BLOCK physical_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_tag_desc
        }
        REPLY
        {
        }
    }
}    

COMMAND read_phys_strategy
{
    BLOCK physical_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_strategy
        }
    }
}

COMMAND write_phys_strategy
{
    BLOCK physical_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_alert_key
{
    BLOCK physical_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_alert_key
        }
    }
}

COMMAND write_phys_alert_key
{
    BLOCK physical_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_target_mode
{
    BLOCK physical_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_target_mode
        }
    }
}

COMMAND write_phys_target_mode
{
    BLOCK physical_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_mode
{
    BLOCK physical_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_actual_mode,
            phys_permitted_mode,
            phys_normal_mode
        }
    }
}

COMMAND read_phys_alarm
{
    BLOCK physical_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_current_state_alarm_sum,
            phys_unacknowledged_state_alarm_sum,
            phys_unreported_state_alarm_sum,
            phys_disabled_state_alarm_sum
        }
    }
}

COMMAND read_phys_software_rev
{
    BLOCK physical_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_software_rev
        }
    }
}

COMMAND read_phys_hardware_rev
{
    BLOCK physical_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_hardware_rev
        }
    }
}

COMMAND read_phys_device_man_id
{
    BLOCK physical_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_man_id
        }
    }
}

COMMAND read_phys_device_id
{
    BLOCK physical_block;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_id
        }
    }
}

COMMAND read_phys_device_ser_num
{
    BLOCK physical_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_ser_num
        }
    }
}
COMMAND read_phys_diagnosis
{
    BLOCK physical_block;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis
        }
    }
}
/*
COMMAND read_phys_diagnosis_extension
{
    BLOCK physical_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_extension
        }
    }
}
*/
COMMAND read_phys_diagnosis_mask
{
    BLOCK physical_block;
    INDEX 15;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_mask
        }
    }
}
/*
COMMAND read_phys_diagnosis_extension_mask
{
    BLOCK physical_block;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_diagnosis_extension_mask
        }
    }
}
*/
COMMAND read_phys_device_certification
{
    BLOCK physical_block;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_device_certification
        }
    }
}

COMMAND read_phys_write_locking
{
    BLOCK physical_block;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_write_locking
        }
    }
}

COMMAND write_phys_write_locking
{
    BLOCK physical_block;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_write_locking
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_factory_reset
{
    BLOCK physical_block;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_factory_reset
        }
    }
}

COMMAND write_phys_factory_reset
{
    BLOCK physical_block;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_factory_reset
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_descriptor
{
    BLOCK physical_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_descriptor
        }
    }
}

COMMAND write_phys_descriptor
{
    BLOCK physical_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_descriptor
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_message
{
    BLOCK physical_block;
    INDEX 21;
    OPERATION  READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_message
        }
    }
}

COMMAND write_phys_message
{
    BLOCK physical_block;
    INDEX 21;
    OPERATION  WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_message
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_install_date
{
    BLOCK physical_block;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_install_date
        }
    }
}

COMMAND write_phys_install_date
{
    BLOCK physical_block;
    INDEX 22;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_install_date
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_local_operation_enable
{
    BLOCK physical_block;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_local_operation_enable
        }
    }
}

COMMAND write_phys_local_operation_enable
{
    BLOCK physical_block;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_local_operation_enable
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_ident_number
{
    BLOCK physical_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_ident_number
        }
    }
}

COMMAND write_phys_ident_number
{
    BLOCK physical_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            phys_ident_number
        }
        REPLY
        {
        }
    }
}

COMMAND read_phys_hw_write_protection
{
    BLOCK physical_block;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            phys_hw_write_protection
        }
    }
}

/*---------------------------------------------------------------------*/
/*    Physical Block: (Menus and Windows)                              */
/*---------------------------------------------------------------------*/
MENU OnlineDialog_reset
{
    LABEL       [master_reset];
    HELP        [master_reset_help];
    ITEMS
    {
        Page_reset
    }
}

MENU Page_reset
{
    LABEL       [master_reset];
    HELP        [master_reset_help];
    ITEMS
    {
        phys_diagnosis,
        COLUMNBREAK,
        //method_save_as_user_default,
        //method_load_user_default,
        method_phys_factory_reset_params,
        method_phys_factory_reset_warm,
        method_phys_factory_reset_address
    }
}

METHOD method_phys_factory_reset_params
{
    LABEL       [factory_reset_PARAMS];
    DEFINITION
    {
        int status;

        ACKNOWLEDGE([factory_reset_PARAMS]);

        phys_factory_reset = 1;    

        status = WriteCommand (write_phys_factory_reset);
    }
}

METHOD method_save_as_user_default
{
    LABEL        "Save as user default";
    DEFINITION
    {
        int status;

        ACKNOWLEDGE("Save params as factory.");

        phys_factory_reset = 32768;    

        status = WriteCommand (write_phys_factory_reset);
    }
}

METHOD method_load_user_default
{
    LABEL        "Load user default";
    DEFINITION
    {
        int status;

        ACKNOWLEDGE("Load user default");

        phys_factory_reset = 32769;    

        status = WriteCommand (write_phys_factory_reset);
    }
}

METHOD method_phys_factory_reset_warm
{
    LABEL       [phys_device_reset_cmd];
    DEFINITION
    {
        int status;
        char sz[512];
        int iLen;
		
		iLen = 512;
        get_dictionary_string(phys_device_reset_cmd, sz, iLen) ;

        sz += "\r\n\r\n" ;
        sz += [note_connection_will_be_aborted] ;

        ACKNOWLEDGE(sz);

        phys_factory_reset = PHYS_FACTORY_RESET_CMD ;

        status = WriteCommand (write_phys_factory_reset);

        if( status == 17456 )
        {
            ACKNOWLEDGE([not_supported]) ;
        }
    }
}

METHOD method_phys_factory_reset_address
{
    LABEL       [factory_reset_ADDRESS];
    DEFINITION
    {
        int status;
        char sz[512];
        int iLen;
		
		iLen = 512;
        get_dictionary_string(factory_reset_ADDRESS, sz, iLen) ;

        sz += "\r\n\r\n" ;
        sz += [note_connection_will_be_aborted] ;

        ACKNOWLEDGE(sz);

        phys_factory_reset = PHYS_FACTORY_RESET_ADDRESS; 

        status = WriteCommand (write_phys_factory_reset);

        if( status == 17456 )
        {
            ACKNOWLEDGE([not_supported]) ;
        }
	}
}

MENU OnlineDialog_ident_number
{
    LABEL     [MC_Idnet_Number_Select];
    ITEMS
    {
        phys_ident_number
    }
}

MENU Page_diagnosis_general
{
    LABEL       [menu_dialog_general];
    ITEMS
    {
        phys_tag_desc           (READ_ONLY),
        phys_device_man_id,
        phys_device_id,
        phys_device_ser_num,
        phys_software_rev,
        phys_hardware_rev,
        phys_install_date       (READ_ONLY),
        phys_write_locking      (READ_ONLY),
        phys_diagnosis
    }
}

MENU Page_diagnosis_phys_block
{
    LABEL       [blk_block_object_PHYSICAL];
    ITEMS
    {
        phys_blk_object,
        phys_blk_parent_class,
        phys_blk_class,
        phys_blk_dd_reference,
        phys_blk_dd_rev,
        phys_blk_profile,
        phys_blk_profile_rev,
        phys_st_rev,
        phys_actual_mode
    }
}

/*---------------------------------------------------------------------*/
/*    Physical Block: (Table - Specialist)                             */
/*---------------------------------------------------------------------*/
MENU Tab_s_manuf_info
{
    LABEL    [MC_Tab_manuf_info];
    ITEMS
    {
        phys_device_man_id,
        phys_device_id
    }
}

MENU Tab_s_get_info
{
    LABEL    [MC_Tab_get_info];
    ITEMS
    {
        phys_descriptor,
        phys_message,
        phys_install_date,
    }
}

MENU Tab_device_revisions
{
    LABEL    [MC_Tab_device_revisions];
    ITEMS
    {
        phys_st_rev,
        phys_software_rev,
        phys_hardware_rev,
        phys_blk_profile,
        phys_blk_profile_rev,
        phys_blk_dd_reference,
        phys_blk_dd_rev
    }
}

MENU Tab_s_certificates
{
    LABEL        [menu_certificates];
    ITEMS
    {
        phys_device_certification    (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    Physical Block: (Table - Maintenance)                            */
/*---------------------------------------------------------------------*/
MENU Tab_m_manuf_info
{
    LABEL   [MC_Tab_manuf_info];
    ITEMS
    {
        phys_device_man_id,
        phys_device_id
    }
}

MENU Tab_m_get_info
{
    LABEL   [MC_Tab_get_info];
    ITEMS
    {
        phys_descriptor,
        phys_message,
        phys_install_date    (READ_ONLY),
    }
}

MENU Tab_m_certificates
{
    LABEL   [menu_certificates];
    ITEMS
    {
        phys_device_certification    (READ_ONLY)
    }
}

MENU OnlineDialog_write_locking
{
    LABEL   [phys_write_locking];
    HELP    [phys_write_locking_help];
    ITEMS
    {
        phys_write_locking,
        phys_hw_write_protection,
        COLUMNBREAK,
        method_set
    }
}